(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    168201,       4446]
NotebookOptionsPosition[    160974,       4308]
NotebookOutlinePosition[    161370,       4324]
CellTagsIndexPosition[    161327,       4321]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Squares - arbitrary point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 3.947481338032559*^9}, {
   3.954751035600836*^9, 3.954751041551665*^9}, 
   3.961113073934698*^9},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about squares in the paper \
\[OpenCurlyDoubleQuote]More Shapes of Central Quadrilaterals\
\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 3.947481347432724*^9}, {
  3.9547510672960033`*^9, 3.9547510732974434`*^9}, {3.961411499804756*^9, 
  3.961411507363937*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{"ptB", ",", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"square", "=", 
   RowBox[{
    RowBox[{"b", "==", 
     RowBox[{
      SqrtBox["2"], "a"}]}], "&&", 
    RowBox[{"c", "==", "a"}], "&&", 
    RowBox[{"S", "==", 
     RowBox[{"a", "^", "2"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.947481378154803*^9, 3.947481389864706*^9}, {3.954663533219055*^9, 
   3.9546635356984367`*^9}, {3.95475109460137*^9, 3.954751099533167*^9}},
 CellLabel->
  "In[590]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fd26d20d-f63d-134d-9522-\
07cd05560e53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"tests", " ", "for", " ", "orthogonal"}], "||", "equidiagonal", "||",
      "square", "||", 
     RowBox[{"cyclic", " ", "quadrilateral"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"orthodiagonalQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"perpendicularQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P", ",", "R"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "S"}], "]"}], ",", "cond"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"equidiagonalQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Numerator", "[", 
         RowBox[{"Factor", "[", 
          RowBox[{
           RowBox[{"CuadradoDistancia", "[", 
            RowBox[{"P", ",", "R"}], "]"}], "-", 
           RowBox[{"CuadradoDistancia", "[", 
            RowBox[{"Q", ",", "S"}], "]"}]}], "]"}], "]"}], ",", "cond"}], 
       "]"}], "==", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"squareQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"And", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"parallelQ", "[", 
         RowBox[{
          RowBox[{"Recta", "[", 
           RowBox[{"P", ",", "Q"}], "]"}], ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"R", ",", "S"}], "]"}], ",", "cond"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Factor", "[", 
           RowBox[{
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"P", ",", "Q"}], "]"}], "-", 
            RowBox[{"CuadradoDistancia", "[", 
             RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "cond"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cyclicQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptP_", ",", "ptQ_", ",", "ptR_", ",", "ptS_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "ptO", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ptO", "=", 
         RowBox[{"Circuncentro", "[", 
          RowBox[{"{", 
           RowBox[{"ptP", ",", "ptQ", ",", "ptR"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"Numerator", "[", 
            RowBox[{"Factor", "[", 
             RowBox[{
              RowBox[{"CuadradoDistancia", "[", 
               RowBox[{"ptO", ",", "ptP"}], "]"}], "-", 
              RowBox[{"CuadradoDistancia", "[", 
               RowBox[{"ptO", ",", "ptS"}], "]"}]}], "]"}], "]"}], ",", 
           "cond"}], "]"}], "==", "0"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
   3.947133479684403*^9, 3.947133480044634*^9}, {3.954749394336471*^9, 
   3.954749396294033*^9}, {3.954750090329485*^9, 3.954750131865982*^9}, {
   3.954753028947459*^9, 3.954753029904716*^9}, {3.954754113835903*^9, 
   3.9547541905064087`*^9}, {3.9547542210272903`*^9, 3.95475439052907*^9}, {
   3.954754423812105*^9, 3.954754424854297*^9}, 3.96141365618578*^9},
 CellLabel->
  "In[594]:=",ExpressionUUID->"40e59fb8-57aa-a44c-b3ad-e5271e9b1dbb"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztvQtcFNX//z/L3wIerfYjv/qRPl7QjTLSVPCGWoIXvIWoiVfUTLwkiiFe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    "], {{0, 133.1320754716981}, {537.2830188679245, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{537.2830188679245, 133.1320754716981},
  PlotRange->{{0, 537.2830188679245}, {0, 133.1320754716981}}]], "Text",
 CellChangeTimes->{3.946440201275278*^9, 3.947481441080046*^9, 
  3.9546637025505314`*^9, 3.9611124720532055`*^9, 
  3.961112506620304*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ptE", "=", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "arbitrary", " ", "point", " ", "in", " ", "the", " ", "plane", " ", "of", 
    " ", "ABCD"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.954749532942322*^9, 3.954749537988825*^9}, {
   3.954749857929596*^9, 3.954749858260048*^9}, {3.9547500230388584`*^9, 
   3.95475002381987*^9}, 3.954750167904394*^9, {3.954751290359585*^9, 
   3.954751380810285*^9}, {3.954751447725331*^9, 3.9547514694606247`*^9}, {
   3.95475155243356*^9, 3.954751579498605*^9}, {3.9547516370107365`*^9, 
   3.954751637904064*^9}, {3.954752239813*^9, 3.954752239922849*^9}, {
   3.954752334722977*^9, 3.954752335702133*^9}, {3.95475302195581*^9, 
   3.954753038968864*^9}, {3.954754435346636*^9, 3.9547544490091343`*^9}},
 CellLabel->
  "In[606]:=",ExpressionUUID->"0d669dd5-dbb6-5146-8f3d-a6e12ef608f4"],

Cell[CellGroupData[{

Cell["X (2) ", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, 
   3.954641020631277*^9, {3.954664290377915*^9, 3.954664346248628*^9}, {
   3.9547514951913757`*^9, 
   3.954751495551979*^9}},ExpressionUUID->"8fd42271-cf5a-0f4a-8f01-\
7961a2ee714f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"2", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.947482791814049*^9, 3.9474827919895*^9}, {
  3.954641025192749*^9, 3.954641045000105*^9}, {3.954655870127039*^9, 
  3.954655877192208*^9}, {3.954655920614462*^9, 3.954655934846636*^9}, {
  3.954751216537081*^9, 3.9547512173122444`*^9}, {3.95475442381411*^9, 
  3.95475442485532*^9}},
 CellLabel->
  "In[607]:=",ExpressionUUID->"d3a0b9b1-1d50-9e4b-8467-aed168b5a1e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ",", 
     RowBox[{"u", "+", 
      RowBox[{"2", " ", "v"}], "+", "w"}], ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"u", "+", 
      RowBox[{"2", " ", "v"}], "+", "w"}], ",", 
     RowBox[{"u", "+", "v", "+", 
      RowBox[{"2", " ", "w"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "u"}], "+", "v", "+", "w"}], ",", 
     RowBox[{
      RowBox[{"-", "u"}], "-", "w"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "u"}], "+", 
      RowBox[{"2", " ", "v"}], "+", 
      RowBox[{"3", " ", "w"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "u"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "u"}], "-", "w"}], ",", 
     RowBox[{"u", "+", "v", "+", 
      RowBox[{"2", " ", "w"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947482792658448*^9, 3.954641046165779*^9, 
  3.95465587874625*^9, 3.954655936107866*^9, 3.954658815391087*^9, 
  3.954660680571306*^9, 3.954660747541697*^9, 3.954660813602222*^9, 
  3.9546637949697037`*^9, 3.95475124144734*^9, 3.9547514135205092`*^9, 
  3.9611125732698956`*^9, 3.9614115149915667`*^9, 3.961413678856887*^9},
 CellLabel->
  "Out[607]=",ExpressionUUID->"c4e0b672-fb40-4cb5-87b1-5089301134b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"squareQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954751423652748*^9, 3.9547514393371964`*^9}, {
  3.954751586697972*^9, 3.954751590185423*^9}},
 CellLabel->
  "In[608]:=",ExpressionUUID->"d222f9f4-9781-3f42-8849-7c89e9a135a7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954751440598404*^9, 3.954751477262398*^9, 
  3.95475159089691*^9, 3.961112579177582*^9, 3.961411515036934*^9, 
  3.9614136789269238`*^9},
 CellLabel->
  "Out[608]=",ExpressionUUID->"66839b70-e34f-41c0-9912-29ec0c10013d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (99)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.947481462233315*^9}, {
  3.954664377512268*^9, 
  3.9546643786092434`*^9}},ExpressionUUID->"990a55c4-883d-5442-8fbf-\
2dbb85b093b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Simplificar", "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"99", ",", "ptE"}], "]"}], "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x_", "-", "y_"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x_", "+", "y_"}], ")"}]}], "->", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["y", "2"]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x_"}], "+", "y_"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x_", "+", "y_"}], ")"}]}], "->", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "+", 
         SuperscriptBox["y", "2"]}]}]}], "}"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.947481663496107*^9, 3.947481665447899*^9}, {
   3.954664384491232*^9, 3.954664389154089*^9}, {3.954664435860365*^9, 
   3.9546644758610973`*^9}, 3.954666460345459*^9, {3.9547515121697407`*^9, 
   3.9547515124652233`*^9}, {3.954754423816107*^9, 3.954754424857321*^9}},
 CellLabel->
  "In[609]:=",ExpressionUUID->"a51e3372-af24-ce43-8f2d-a262f2467327"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", "u", " ", "w"}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "w", " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "w"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", "v", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "2"]}], ")"}]}], "+", 
          RowBox[{"w", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{"v", "+", "w"}], ")"}]}], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"v", "+", "w"}], ")"}], "2"]}], ")"}]}], "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{"v", "+", 
                   RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
          ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "v", " ", "w"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "w", " ", 
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"2", " ", "u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}], "+", 
             RowBox[{"w", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"w", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                SuperscriptBox["v", "2"], "+", 
                RowBox[{"v", " ", "w"}], "+", 
                SuperscriptBox["w", "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{"v", "+", 
                   RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], "-", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{"v", "+", 
                   RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
          ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "w"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "v", " ", "w"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"2", " ", "u", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}]}], "+", 
           RowBox[{"w", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", "u", " ", "w"}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "w"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
           RowBox[{"u", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "u"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", "u", " ", "v"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"w", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
           RowBox[{"u", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", 
              RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", "u", " ", "w"}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "w"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"u", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
           RowBox[{"v", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", 
              RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"2", " ", "u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "u"}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", "w"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", "u", " ", "v"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "v"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"w", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["c", "2"]}], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"2", " ", "u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "v", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", "u", " ", "w"}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "w"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
             RowBox[{"v", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", "u", " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "v"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "v", " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "v"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "v"}], "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "v"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"2", " ", "v", " ", "w"}], "+", 
             RowBox[{"w", " ", 
              RowBox[{"(", 
               RowBox[{"u", "+", "w"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"u", "+", "v"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "3"], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"v", "+", "w"}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["u", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "v"}], "+", 
                RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", 
                 SuperscriptBox["v", "2"]}], "+", 
                RowBox[{"5", " ", "v", " ", "w"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"3", " ", "u", " ", "v"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"2", " ", "u", " ", "w"}], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"3", " ", "u", " ", "v"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"2", " ", "u", " ", "w"}], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"], "+", 
           RowBox[{"2", " ", "u", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}], "2"], "+", 
           RowBox[{"u", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "v"}], "+", 
              RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"u", "+", "v"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["u", "3"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["u", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}]}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}], "3"], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"5", " ", "v", " ", "w"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"u", "+", "v"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["u", "3"], "+", 
         SuperscriptBox["v", "3"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"4", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         SuperscriptBox["w", "3"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["u", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"v", "+", "w"}], ")"}]}], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"7", " ", "v", " ", "w"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "v"}], "+", "w"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["u", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "v"}], "+", 
            RowBox[{"3", " ", "w"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["u", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"3", " ", "v", " ", "w"}], "+", 
            SuperscriptBox["w", "2"]}], ")"}]}], "+", 
         RowBox[{"2", " ", "u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["v", "3"]}], "+", 
            RowBox[{"13", " ", 
             SuperscriptBox["v", "2"], " ", "w"}], "+", 
            RowBox[{"9", " ", "v", " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", "4"], " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["u", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"3", " ", "v", " ", "w"}], "+", 
            SuperscriptBox["w", "2"]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["u", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["v", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["v", "2"], " ", "w"}], "+", 
            RowBox[{"7", " ", "v", " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SuperscriptBox["v", "4"]}], "+", 
            RowBox[{"34", " ", 
             SuperscriptBox["v", "3"], " ", "w"}], "+", 
            RowBox[{"37", " ", 
             SuperscriptBox["v", "2"], " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"19", " ", "v", " ", 
             SuperscriptBox["w", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["w", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "v"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["u", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["v", "3"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["v", "2"], " ", "w"}], "+", 
            RowBox[{"7", " ", "v", " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["w", "3"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", "v"}], "+", 
               RowBox[{"5", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"10", " ", "v", " ", "w"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["v", "4"]}], "+", 
            RowBox[{"13", " ", 
             SuperscriptBox["v", "3"], " ", "w"}], "+", 
            RowBox[{"14", " ", 
             SuperscriptBox["v", "2"], " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"6", " ", "v", " ", 
             SuperscriptBox["w", "3"]}], "+", 
            SuperscriptBox["w", "4"], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["u", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "v"}], "+", "w"}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"12", " ", 
                SuperscriptBox["v", "3"]}], "+", 
               RowBox[{"22", " ", 
                SuperscriptBox["v", "2"], " ", "w"}], "+", 
               RowBox[{"14", " ", "v", " ", 
                SuperscriptBox["w", "2"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["u", "5"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], "3"]}], "+", 
         RowBox[{
          SuperscriptBox["u", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "v"}], "+", 
            RowBox[{"4", " ", "w"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["u", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["v", "2"]}], "+", 
            RowBox[{"19", " ", "v", " ", "w"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["u", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"22", " ", 
             SuperscriptBox["v", "3"]}], "+", 
            RowBox[{"37", " ", 
             SuperscriptBox["v", "2"], " ", "w"}], "+", 
            RowBox[{"21", " ", "v", " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["v", "4"]}], "+", 
            RowBox[{"34", " ", 
             SuperscriptBox["v", "3"], " ", "w"}], "+", 
            RowBox[{"27", " ", 
             SuperscriptBox["v", "2"], " ", 
             SuperscriptBox["w", "2"]}], "+", 
            RowBox[{"8", " ", "v", " ", 
             SuperscriptBox["w", "3"]}], "+", 
            SuperscriptBox["w", "4"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"v", "+", "w"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["u", "3"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}], "3"], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "v"}], "+", 
               RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"5", " ", "v", " ", "w"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["u", "3"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}], "3"], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "v"}], "+", 
               RowBox[{"3", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"7", " ", "v", " ", "w"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["u", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "3"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"7", " ", "v"}], "+", 
               RowBox[{"5", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"7", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"10", " ", "v", " ", "w"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["u", "4"], "+", 
            RowBox[{"4", " ", "v", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["u", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"14", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"14", " ", "v", " ", "w"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"13", " ", 
                SuperscriptBox["v", "3"]}], "+", 
               RowBox[{"22", " ", 
                SuperscriptBox["v", "2"], " ", "w"}], "+", 
               RowBox[{"12", " ", "v", " ", 
                SuperscriptBox["w", "2"]}], "+", 
               SuperscriptBox["w", "3"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["u", "4"], "+", 
            RowBox[{"4", " ", "v", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}], "3"]}], "+", 
            RowBox[{
             SuperscriptBox["u", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"7", " ", "v"}], "+", 
               RowBox[{"4", " ", "w"}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["u", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", 
                SuperscriptBox["v", "2"]}], "+", 
               RowBox[{"6", " ", "v", " ", "w"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"13", " ", 
                SuperscriptBox["v", "3"]}], "+", 
               RowBox[{"26", " ", 
                SuperscriptBox["v", "2"], " ", "w"}], "+", 
               RowBox[{"18", " ", "v", " ", 
                SuperscriptBox["w", "2"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
      ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "v"}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", "w"}]}], ")"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"], "+", 
           RowBox[{"2", " ", "u", " ", 
            RowBox[{"(", 
             RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"u", "+", "v"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           RowBox[{"3", " ", "u", " ", "v"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"2", " ", "u", " ", "w"}], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"3", " ", "u", " ", "v"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["v", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", "w"}], "+", 
              RowBox[{"2", " ", "v", " ", "w"}], "+", 
              SuperscriptBox["w", "2"]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["u", "2"], "+", 
              RowBox[{"3", " ", "u", " ", "v"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["v", "2"]}], "+", 
              RowBox[{"2", " ", "u", " ", "w"}], "+", 
              RowBox[{"3", " ", "v", " ", "w"}], "+", 
              SuperscriptBox["w", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"v", "+", "w"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["c", "2"], " ", "v"}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "w"}]}], ")"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "2"], "+", 
             SuperscriptBox["v", "2"], "+", 
             RowBox[{"3", " ", "v", " ", "w"}], "+", 
             SuperscriptBox["w", "2"], "+", 
             RowBox[{"2", " ", "u", " ", 
              RowBox[{"(", 
               RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["u", "3"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["v", "3"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["v", "2"], " ", "w"}], "+", 
             RowBox[{"3", " ", "v", " ", 
              SuperscriptBox["w", "2"]}], "+", 
             SuperscriptBox["w", "3"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["u", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"5", " ", 
                 SuperscriptBox["v", "2"]}], "+", 
                RowBox[{"5", " ", "v", " ", "w"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"v", "+", "w"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["c", "2"]}], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                SuperscriptBox["v", "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["u", "2"], "+", 
                SuperscriptBox["v", "2"], "+", 
                RowBox[{"v", " ", "w"}], "+", 
                SuperscriptBox["w", "2"], "+", 
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947481666678438*^9, 3.947481684054268*^9}, 
   3.954664391336399*^9, {3.9546644505659237`*^9, 3.954664477237171*^9}, 
   3.9546664621565933`*^9, 3.954721630042843*^9, {3.95472701260157*^9, 
   3.954727035978617*^9}, 3.954727203409839*^9, 3.9547516113827286`*^9, 
   3.9611125947929115`*^9, 3.961411517936058*^9, 3.961413681603971*^9},
 CellLabel->
  "Out[609]=",ExpressionUUID->"f677a9cb-9fb0-4776-815c-a662790e1126"]
}, Open  ]],

Cell["\<\
E,F,G,H and E,F,G,I are  concyclic. Therefore E,F,G,H,I are concyclic\
\>", "Text",
 CellChangeTimes->{{3.9547216480459375`*^9, 
  3.954721733290882*^9}},ExpressionUUID->"8b9fce3a-19d0-4f46-8ff2-\
a8f3d086a522"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cyclicQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.95466669803442*^9, 3.9546667260273495`*^9}},
 CellLabel->
  "In[610]:=",ExpressionUUID->"89436e68-f0dd-e544-8745-b97398d16c1f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9546667284983788`*^9, 3.954721638832049*^9, 
  3.9547516208828692`*^9, 3.961112613387598*^9, 3.961411522477428*^9, 
  3.961413685629239*^9},
 CellLabel->
  "Out[610]=",ExpressionUUID->"05da347e-ef53-4460-b101-31ccbc362722"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cyclicQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{3.954666737540592*^9},
 CellLabel->
  "In[611]:=",ExpressionUUID->"12b9d76c-208a-4943-803e-b5b8e79d1a9b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.95466673985705*^9, 3.954721640126049*^9, 
  3.954751625320827*^9, 3.9611126162950573`*^9, 3.961411525071787*^9, 
  3.961413689523522*^9},
 CellLabel->
  "Out[611]=",ExpressionUUID->"a0570986-25c8-444e-9677-9dec8e3ceb3d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (925)", "Subsection",
 CellChangeTimes->{{3.94748145699555*^9, 3.947481462233315*^9}, {
  3.954664377512268*^9, 3.9546643786092434`*^9}, {3.9546668060740223`*^9, 
  3.954666806978407*^9}, {3.954669340931949*^9, 3.954669341700636*^9}, {
  3.954671845452841*^9, 3.954671846989153*^9}, {3.954723839675102*^9, 
  3.954723840091212*^9}},ExpressionUUID->"4bf33b8f-3b04-5345-986a-\
164c8bc1a5d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptX", "=", 
  RowBox[{
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"925", ",", "2"}], "]"}], "]"}], "/.", "sustS"}], "/.", 
     "sustC"}], "]"}], "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x_", "-", "y_"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x_", "+", "y_"}], ")"}]}], "->", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "x_"}], "+", "y_"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x_", "+", "y_"}], ")"}]}], "->", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["y", "2"]}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.954722705558529*^9, 3.9547227133503075`*^9}, {
   3.9547228306850758`*^9, 3.954722845611655*^9}, {3.954722875765003*^9, 
   3.954722877236286*^9}, 3.954723480368191*^9},
 CellLabel->
  "In[612]:=",ExpressionUUID->"d4b5270a-e4d4-9940-8939-6925cfddae05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.954722713551337*^9, {3.954722838333441*^9, 3.954722846511107*^9}, 
   3.954722878093008*^9, 3.954723483211288*^9, 3.954723674803028*^9, 
   3.954751655904413*^9, 3.961112767414383*^9, 3.961411525146186*^9, 
   3.9614136896982613`*^9},
 CellLabel->
  "Out[612]=",ExpressionUUID->"68288e1a-ef0c-4ac1-a352-b9a686fd355e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX", ",", "ptE"}], "]"}], "/.", "sustS"}], "/.", "sustC"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "/@", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", "#", "]"}], "/.", "sustS"}], ",", "square"}], 
      "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.9547517844185944`*^9, 3.954751785305981*^9}, {
  3.954751846642699*^9, 3.954751892065235*^9}, {3.954751944298748*^9, 
  3.9547519880983753`*^9}, {3.954754423819105*^9, 3.954754424859323*^9}},
 CellLabel->
  "In[613]:=",ExpressionUUID->"8880ba85-22ad-d649-b4c9-ec38ff0e6f28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "u"}], "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "u", " ", 
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"6", " ", "v", " ", "w"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"2", " ", "w"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["w", "2"], "+", 
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"v", " ", 
         SuperscriptBox["w", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         SuperscriptBox["w", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"v", "+", 
            RowBox[{"2", " ", "w"}]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["u", "3"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "v"}], "+", 
           RowBox[{"4", " ", "w"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"6", " ", "v", " ", "w"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", "w", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "u"}], "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"2", " ", "w"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["w", "2"], "+", 
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", "u", " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u"}], "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "-", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        RowBox[{"2", " ", "u", " ", "w"}], "-", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u"}], "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["u", "2"]}], "+", 
        RowBox[{"2", " ", "u", " ", "w"}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "2"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "-", 
           RowBox[{"6", " ", "w"}]}], ")"}], " ", "w"}], "-", 
        RowBox[{"u", " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "-", 
           RowBox[{"4", " ", "w"}]}], ")"}], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["w", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "-", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", "u", " ", "v", " ", 
         SuperscriptBox["w", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u"}], "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", "w"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["u", "2"]}], "+", 
        RowBox[{"2", " ", "u", " ", "w"}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["u", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "-", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["v", "2"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
        RowBox[{"2", " ", "u", " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "-", 
           RowBox[{"4", " ", "v", " ", "w"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "u"}], "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["u", "2"]}], "+", 
        RowBox[{"2", " ", "u", " ", "w"}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"]}], "-", 
           RowBox[{"v", " ", "w"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
        RowBox[{"u", " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"13", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["v", "4"], " ", 
         SuperscriptBox["w", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "v"}], "+", "w"}], ")"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["u", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"3", " ", "v", " ", "w"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "3"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "-", 
           RowBox[{"4", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "u", " ", 
         SuperscriptBox["v", "3"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["v", "3"], " ", "w"}], "+", 
           RowBox[{"21", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"15", " ", "v", " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["w", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["v", "4"]}], "+", 
           RowBox[{"13", " ", 
            SuperscriptBox["v", "3"], " ", "w"}], "+", 
           RowBox[{"32", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"16", " ", "v", " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "3"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "5"], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["v", "4"], " ", "w"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"38", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"18", " ", "v", " ", 
            SuperscriptBox["w", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "5"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "2"], " ", 
         SuperscriptBox["v", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "5"]}], "+", 
           RowBox[{"14", " ", 
            SuperscriptBox["v", "4"], " ", "w"}], "+", 
           RowBox[{"31", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"60", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"33", " ", "v", " ", 
            SuperscriptBox["w", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["w", "5"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["v", "5"]}], "-", 
           RowBox[{"25", " ", 
            SuperscriptBox["v", "4"], " ", "w"}], "-", 
           RowBox[{"52", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"24", " ", "v", " ", 
            SuperscriptBox["w", "4"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["w", "5"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"v", "-", "w"}], ")"}], "2"], " ", 
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"5", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "4"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["v", "3"], " ", "w"}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"4", " ", "v", " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["w", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["v", "5"]}], "+", 
           RowBox[{"30", " ", 
            SuperscriptBox["v", "4"], " ", "w"}], "+", 
           RowBox[{"66", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"36", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"24", " ", "v", " ", 
            SuperscriptBox["w", "4"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["w", "5"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "6"]}], "+", 
           RowBox[{"21", " ", 
            SuperscriptBox["v", "5"], " ", "w"}], "+", 
           RowBox[{"60", " ", 
            SuperscriptBox["v", "4"], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"38", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "3"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "4"]}], "-", 
           RowBox[{"16", " ", "v", " ", 
            SuperscriptBox["w", "5"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "6"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "2"], " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            SuperscriptBox["v", "6"]}], "+", 
           RowBox[{"31", " ", 
            SuperscriptBox["v", "5"], " ", "w"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["v", "4"], " ", 
            SuperscriptBox["w", "2"]}], "-", 
           RowBox[{"26", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "3"]}], "-", 
           RowBox[{"32", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "4"]}], "-", 
           RowBox[{"4", " ", "v", " ", 
            SuperscriptBox["w", "5"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "6"]}]}], ")"}]}], "+", 
        RowBox[{"u", " ", "v", " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["v", "6"]}], "+", 
           RowBox[{"28", " ", 
            SuperscriptBox["v", "5"], " ", "w"}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["v", "4"], " ", 
            SuperscriptBox["w", "2"]}], "-", 
           RowBox[{"25", " ", 
            SuperscriptBox["v", "3"], " ", 
            SuperscriptBox["w", "3"]}], "-", 
           RowBox[{"26", " ", 
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["w", "4"]}], "+", 
           RowBox[{"6", " ", "v", " ", 
            SuperscriptBox["w", "5"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["w", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"2", " ", "w"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["w", "2"], "+", 
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "3"], " ", "v", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", 
           RowBox[{"4", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{"v", " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "-", 
           RowBox[{"v", " ", 
            SuperscriptBox["w", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}], "-", 
        RowBox[{"u", " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"4", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{"13", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"6", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["S", "6"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", "v"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"v", "+", 
        RowBox[{"2", " ", "w"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "-", 
        SuperscriptBox["w", "2"], "+", 
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"2", " ", "v", " ", "w"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "-", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["v", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"2", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "u", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "3"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"2", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9547517762653112`*^9, 3.9547518093531303`*^9, 3.954751918239586*^9, {
   3.954751974818521*^9, 3.954752002850609*^9}, 3.961112783410698*^9, 
   3.961411544536574*^9, 3.96141370609863*^9},
 CellLabel->
  "Out[614]=",ExpressionUUID->"87bfb54d-5990-4ba7-99f5-240484103243"]
}, Open  ]],

Cell["\<\
E,F,G,H and E,F,G,I are  concyclic. Therefore E,F,G,H,I are concyclic\
\>", "Text",
 CellChangeTimes->{{3.9547216480459375`*^9, 
  3.954721733290882*^9}},ExpressionUUID->"e435e2a0-0d6f-7e4b-8e57-\
4d9e2a83c27e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cyclicQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954722756254359*^9, 3.954722771340098*^9}, 
   3.954723286518961*^9, {3.954723327917002*^9, 3.9547233290043354`*^9}, {
   3.9547233764537773`*^9, 3.954723384144558*^9}},
 CellLabel->
  "In[615]:=",ExpressionUUID->"583b583c-c47a-4746-8a1b-24153bdbb7a2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9547520530195646`*^9, 3.961112805726898*^9, 
  3.961411570035098*^9, 3.961413726524885*^9},
 CellLabel->
  "Out[615]=",ExpressionUUID->"dd2ef6e3-c71e-4a7e-9fa0-7132ffea9739"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cyclicQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{3.954723408663613*^9},
 CellLabel->
  "In[616]:=",ExpressionUUID->"aaf6b549-d5ad-b442-8e4f-7299e3b31959"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954752074488058*^9, 3.9611128190997314`*^9, 
  3.961411588716357*^9, 3.961413745494186*^9},
 CellLabel->
  "Out[616]=",ExpressionUUID->"a0844f66-94c7-4351-b1cb-a50289a6c25d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (372)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, 
   3.954641020631277*^9, {3.954664290377915*^9, 3.954664346248628*^9}, {
   3.954669430940346*^9, 
   3.954669433058708*^9}},ExpressionUUID->"00923344-6d28-7946-be9c-\
f9485f0ad95f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"372", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"#", ",", "square"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.947482791814049*^9, 3.9474827919895*^9}, {
  3.954641025192749*^9, 3.954641045000105*^9}, {3.954655870127039*^9, 
  3.954655877192208*^9}, {3.954655920614462*^9, 3.954655934846636*^9}, {
  3.954669440134119*^9, 3.954669440636837*^9}, {3.954752134881607*^9, 
  3.954752144090332*^9}, {3.954754423821108*^9, 3.9547544248613224`*^9}},
 CellLabel->
  "In[617]:=",ExpressionUUID->"789bf8c7-b82e-754f-8665-c836edfa3e5d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"u", " ", "v"}], "-", 
      RowBox[{"v", " ", "w"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["v", "2"], "+", 
        RowBox[{"v", " ", "w"}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "u"}], "+", "w"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"v", " ", "w"}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", 
         RowBox[{"2", " ", "w"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"v", " ", "w"}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", 
         RowBox[{"2", " ", "w"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "2"], "+", 
        SuperscriptBox["v", "2"], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{"v", "-", "w"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "u"}], " ", "v"}], "+", 
      RowBox[{"w", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", 
         RowBox[{"2", " ", "w"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"u", " ", "v"}], "-", 
      RowBox[{"v", " ", "w"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", "w"}], "+", 
      RowBox[{"2", " ", "v", " ", "w"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "2"]}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"v", "-", 
         RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{"v", " ", "w"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "2"]}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{"v", "-", 
         RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{"v", " ", "w"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "2"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["w", "2"]}], "+", 
      RowBox[{"2", " ", "u", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "u"}], " ", "v"}], "+", 
      RowBox[{"w", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", 
         RowBox[{"2", " ", "w"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947482792658448*^9, 3.954641046165779*^9, 
  3.95465587874625*^9, 3.954655936107866*^9, 3.954658815391087*^9, 
  3.954660680571306*^9, 3.954660747541697*^9, 3.954660813602222*^9, 
  3.9546637949697037`*^9, 3.954669441795847*^9, 3.954670101359466*^9, 
  3.954670744524639*^9, 3.954726320038301*^9, 3.9547263655706043`*^9, 
  3.954752145243683*^9, 3.9547525621230373`*^9, 3.9611128621309223`*^9, 
  3.961411589496501*^9, 3.961413746378372*^9},
 CellLabel->
  "Out[618]=",ExpressionUUID->"8f398744-c46e-42af-a929-dfd66901cd19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954752187017774*^9, 3.954752198351036*^9}, {
  3.954752247162756*^9, 3.954752247226439*^9}, {3.954752557255806*^9, 
  3.954752558429664*^9}, {3.9547542889899654`*^9, 3.9547543140753345`*^9}, {
  3.9611128681813717`*^9, 3.9611128852906704`*^9}},
 CellLabel->
  "In[619]:=",ExpressionUUID->"cc2aca6d-779d-2c48-bcdc-172906b0cb64"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9611128732089443`*^9, 3.961112886337715*^9}, 
   3.961411589570898*^9, 3.96141374643703*^9},
 CellLabel->
  "Out[619]=",ExpressionUUID->"5d3a642f-7967-4a5f-8ea5-d32be8b58a3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equidiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{3.961112890262108*^9},
 CellLabel->
  "In[620]:=",ExpressionUUID->"8bf784d1-ae2d-bf42-a969-ea1992fbc37a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954752189073004*^9, 3.954752199274059*^9}, 
   3.954752247936844*^9, {3.954752559134836*^9, 3.954752562896347*^9}, 
   3.9611128910560265`*^9, 3.961411589583437*^9, 3.961413746502965*^9},
 CellLabel->
  "Out[620]=",ExpressionUUID->"d6932474-81ae-4f08-b46a-e4d25cff7ae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptB", ",", "ptC"}], "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954726283540348*^9, 3.95472631521429*^9}, {
  3.9547264204545326`*^9, 3.954726422197801*^9}, {3.9547523553753586`*^9, 
  3.954752356161762*^9}, {3.954754242743002*^9, 3.954754242743973*^9}, {
  3.9611129205142994`*^9, 3.9611129232711086`*^9}},
 CellLabel->
  "In[621]:=",ExpressionUUID->"22fdbcb7-5e8c-ef4e-9db4-1e37754dc718"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611129240465736`*^9, 3.961411589655658*^9, 
  3.961413746574718*^9},
 CellLabel->
  "Out[621]=",ExpressionUUID->"5bc7e920-e307-4e88-9fbb-b74348c4842c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptA", ",", "ptB"}], "]"}], ",", "square"}], "]"}]], "Input",
 CellLabel->
  "In[622]:=",ExpressionUUID->"8e6476d7-c515-0247-8abe-b4af00555518"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9547263089588375`*^9, 3.954726423261711*^9, 
  3.954726657374499*^9, 3.954752356895548*^9, 3.9611129252800045`*^9, 
  3.961411589661977*^9, 3.961413746581731*^9},
 CellLabel->
  "Out[622]=",ExpressionUUID->"ff2350ac-e847-45df-8214-3f01f4971ae5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (373)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, 
   3.954641020631277*^9, {3.954664290377915*^9, 3.954664346248628*^9}, {
   3.954669430940346*^9, 3.954669433058708*^9}, {3.954752373298916*^9, 
   3.954752373361873*^9}, 3.9547526882725544`*^9, {3.954753499641617*^9, 
   3.954753548744351*^9}, {3.9547544779500866`*^9, 3.954754485914295*^9}, {
   3.961112985340948*^9, 
   3.961112992181715*^9}},ExpressionUUID->"cd88e62b-4c90-f449-9acc-\
3a1dfa5951b3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"373", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"#", ",", "square"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.947482791814049*^9, 3.9474827919895*^9}, {
  3.954641025192749*^9, 3.954641045000105*^9}, {3.954655870127039*^9, 
  3.954655877192208*^9}, {3.954655920614462*^9, 3.954655934846636*^9}, {
  3.954669440134119*^9, 3.954669440636837*^9}, {3.954752134881607*^9, 
  3.954752144090332*^9}, {3.95475237618614*^9, 3.954752376265447*^9}, {
  3.954754423823105*^9, 3.954754424862322*^9}},
 CellLabel->
  "In[623]:=",ExpressionUUID->"64df9f36-61ea-2047-87d0-46688453da7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"10", " ", "v", " ", "w"}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"12", " ", "v", " ", "w"}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"9", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"13", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"5", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"3", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"14", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"15", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"21", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{"w", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["w", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"6", " ", "v", " ", "w"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"8", " ", "v", " ", "w"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "3"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"], " ", "w"}], "+", 
           RowBox[{"5", " ", "v", " ", 
            SuperscriptBox["w", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["w", "3"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["u", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["u", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
        RowBox[{"v", " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "+", 
        RowBox[{"u", " ", "w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"8", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"5", " ", "v", " ", "w"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["u", "5"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "v"}], "+", "w"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"21", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"18", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"3", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", "v", " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"14", " ", "v", " ", "w"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"15", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["u", "5"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", 
         RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{"3", " ", "u", " ", "v", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "v"}], "+", 
         RowBox[{"11", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"10", " ", "v", " ", "w"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"13", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"13", " ", 
       SuperscriptBox["u", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["u", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"45", " ", "v"}], "+", 
         RowBox[{"7", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"74", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"42", " ", "v", " ", "w"}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"6", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"27", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"34", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"17", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"61", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"57", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"25", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", 
       SuperscriptBox["u", "5"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"3", " ", "v", " ", "w"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"31", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"21", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "-", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"5", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"18", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"22", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"9", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"13", " ", 
       SuperscriptBox["u", "5"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["u", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", "v"}], "+", 
         RowBox[{"3", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"92", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"69", " ", "v", " ", "w"}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"30", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"24", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"50", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"85", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"51", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"92", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"118", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"56", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"13", " ", 
       SuperscriptBox["v", "5"]}], "+", 
      RowBox[{"50", " ", 
       SuperscriptBox["v", "4"], " ", "w"}], "+", 
      RowBox[{"92", " ", 
       SuperscriptBox["v", "3"], " ", 
       SuperscriptBox["w", "2"]}], "+", 
      RowBox[{"92", " ", 
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["w", "3"]}], "+", 
      RowBox[{"50", " ", "v", " ", 
       SuperscriptBox["w", "4"]}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox["w", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"17", " ", "v", " ", "w"}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"24", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"51", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"56", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"30", " ", 
          SuperscriptBox["v", "4"]}], "+", 
         RowBox[{"85", " ", 
          SuperscriptBox["v", "3"], " ", "w"}], "+", 
         RowBox[{"118", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"69", " ", "v", " ", 
          SuperscriptBox["w", "3"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["w", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["u", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"3", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"9", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["v", "4"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["v", "3"], " ", "w"}], "+", 
         RowBox[{"22", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"21", " ", "v", " ", 
          SuperscriptBox["w", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "4"]}]}], ")"}]}], "-", 
      RowBox[{"w", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "4"]}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["v", "3"], " ", "w"}], "+", 
         RowBox[{"31", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"23", " ", "v", " ", 
          SuperscriptBox["w", "3"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["w", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["v", "5"]}], "+", 
      RowBox[{"27", " ", 
       SuperscriptBox["v", "4"], " ", "w"}], "+", 
      RowBox[{"61", " ", 
       SuperscriptBox["v", "3"], " ", 
       SuperscriptBox["w", "2"]}], "+", 
      RowBox[{"74", " ", 
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["w", "3"]}], "+", 
      RowBox[{"45", " ", "v", " ", 
       SuperscriptBox["w", "4"]}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox["w", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["u", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"4", " ", "v", " ", "w"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["v", "3"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["v", "2"], " ", "w"}], "+", 
         RowBox[{"25", " ", "v", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["w", "3"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["v", "4"]}], "+", 
         RowBox[{"34", " ", 
          SuperscriptBox["v", "3"], " ", "w"}], "+", 
         RowBox[{"57", " ", 
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"42", " ", "v", " ", 
          SuperscriptBox["w", "3"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["w", "4"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947482792658448*^9, 3.954641046165779*^9, 3.95465587874625*^9, 
   3.954655936107866*^9, 3.954658815391087*^9, 3.954660680571306*^9, 
   3.954660747541697*^9, 3.954660813602222*^9, 3.9546637949697037`*^9, 
   3.954669441795847*^9, 3.954670101359466*^9, 3.954670744524639*^9, 
   3.954726320038301*^9, 3.9547263655706043`*^9, 3.954752145243683*^9, {
   3.954752380098892*^9, 3.9547524076760063`*^9}, 3.9547531876949635`*^9, 
   3.9611129620904465`*^9, 3.961411593467092*^9, 3.9614137507149887`*^9},
 CellLabel->
  "Out[624]=",ExpressionUUID->"fcfce1f5-31f7-47e5-a4ad-1dae7bf9900a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954752187017774*^9, 3.954752198351036*^9}, {
  3.954752247162756*^9, 3.954752247226439*^9}, {3.954752526927799*^9, 
  3.9547525276340103`*^9}, {3.954754288991963*^9, 3.954754314076332*^9}, {
  3.9611129517905064`*^9, 3.961112973382988*^9}},
 CellLabel->
  "In[625]:=",ExpressionUUID->"c6d28e61-9a1c-204a-98a3-79b11254dd68"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961112974659195*^9, 3.9614115940241337`*^9, 
  3.961413751360465*^9},
 CellLabel->
  "Out[625]=",ExpressionUUID->"2adb7891-1829-4e6f-bfdb-8ec381a697e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equidiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellLabel->
  "In[626]:=",ExpressionUUID->"d0ea322b-4a52-cf42-8296-9d3f28f4f60b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954752189073004*^9, 3.954752199274059*^9}, 
   3.954752247936844*^9, {3.9547523808415375`*^9, 3.9547524101243887`*^9}, 
   3.954752528356497*^9, 3.9547531897519417`*^9, 3.9611129769554234`*^9, 
   3.961411594158392*^9, 3.961413751504572*^9},
 CellLabel->
  "Out[626]=",ExpressionUUID->"39ce5a9d-b4de-45c7-8ef6-edd3d97d36a6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (640)", "Subsection",
 CellChangeTimes->{{3.9474823848969116`*^9, 3.947482389079651*^9}, 
   3.954641020631277*^9, {3.954664290377915*^9, 3.954664346248628*^9}, {
   3.954669430940346*^9, 3.954669433058708*^9}, {3.954752579344105*^9, 
   3.9547525802086983`*^9}},ExpressionUUID->"9e7e0e91-def1-ab49-ad85-\
568e1ef2b97e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptX", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"640", ",", "2"}], "]"}], "]"}], "/.", "sustS"}], "/.", 
       "sustC"}], "]"}], "/.", "sustS"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"ptX", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplificar", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"#", ",", "square"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.947482791814049*^9, 3.9474827919895*^9}, {
  3.954641025192749*^9, 3.954641045000105*^9}, {3.954655870127039*^9, 
  3.954655877192208*^9}, {3.954655920614462*^9, 3.954655934846636*^9}, {
  3.954669440134119*^9, 3.954669440636837*^9}, {3.954752134881607*^9, 
  3.954752144090332*^9}, {3.954752588298208*^9, 3.9547526120515423`*^9}, {
  3.95475264225856*^9, 3.9547526700374336`*^9}, {3.954754423825107*^9, 
  3.9547544248643203`*^9}},
 CellLabel->
  "In[627]:=",ExpressionUUID->"e4231648-b7b6-a946-b923-ff6abdb38f26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["u", "2"], " ", "v"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"5", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"6", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "3"], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "v"}], "+", 
           RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
        RowBox[{"v", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"2", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["u", "2"], " ", "v"}], "-", 
      RowBox[{"w", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["v", "2"], "+", 
         RowBox[{"v", " ", "w"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["v", "2"], "+", 
         RowBox[{"2", " ", "v", " ", "w"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"v", "-", 
         RowBox[{"2", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{"v", "-", 
         RowBox[{"2", " ", "w"}]}], ")"}]}], "+", 
      RowBox[{"v", " ", "w", " ", 
       RowBox[{"(", 
        RowBox[{"v", "+", "w"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["v", "3"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["v", "2"], " ", "w"}], "+", 
        RowBox[{"3", " ", "v", " ", 
         SuperscriptBox["w", "2"]}], "+", 
        SuperscriptBox["w", "3"], "+", 
        RowBox[{
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"2", " ", "v", " ", "w"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"3", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "v"}], "+", 
         RowBox[{"6", " ", "w"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["u", "2"], " ", "v"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"5", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"6", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", "2"], " ", "w"}], "+", 
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"2", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["v", "2"], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["w", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"7", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "v"}], "+", 
         RowBox[{"6", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"10", " ", "v", " ", "w"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"5", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["v", "2"]}], "+", 
         RowBox[{"10", " ", "v", " ", "w"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["w", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["u", "3"], "+", 
        RowBox[{
         SuperscriptBox["v", "2"], " ", "w"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["u", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"v", "+", "w"}], ")"}]}], "+", 
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["v", "2"]}], "+", 
           RowBox[{"4", " ", "v", " ", "w"}], "+", 
           SuperscriptBox["w", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["u", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["v", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["v", "2"], " ", "w"}], "-", 
      RowBox[{"3", " ", "v", " ", 
       SuperscriptBox["w", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["w", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "v"}], "+", 
         RowBox[{"4", " ", "w"}]}], ")"}]}], "-", 
      RowBox[{"u", " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "v"}], "+", 
         RowBox[{"6", " ", "w"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947482792658448*^9, 3.954641046165779*^9, 3.95465587874625*^9, 
   3.954655936107866*^9, 3.954658815391087*^9, 3.954660680571306*^9, 
   3.954660747541697*^9, 3.954660813602222*^9, 3.9546637949697037`*^9, 
   3.954669441795847*^9, 3.954670101359466*^9, 3.954670744524639*^9, 
   3.954726320038301*^9, 3.9547263655706043`*^9, 3.954752145243683*^9, 
   3.9547525621230373`*^9, 3.954752593600261*^9, {3.95475265071142*^9, 
   3.954752672272089*^9}, 3.961113014363899*^9, 3.9614115965303307`*^9, 
   3.961413753803237*^9},
 CellLabel->
  "Out[629]=",ExpressionUUID->"f36acee3-b9f0-46c1-be2d-e478ea05ddee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954752187017774*^9, 3.954752198351036*^9}, {
  3.954752247162756*^9, 3.954752247226439*^9}, {3.954752557255806*^9, 
  3.954752558429664*^9}, {3.954754288992956*^9, 3.9547543140773315`*^9}, {
  3.9611130183189144`*^9, 3.9611130265750504`*^9}},
 CellLabel->
  "In[630]:=",ExpressionUUID->"5864f068-f9e6-4645-b8e4-ada1edce89c9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.961113027398367*^9, 3.961411596624214*^9, 
  3.961413753967826*^9},
 CellLabel->
  "Out[630]=",ExpressionUUID->"89e023a3-78f1-4f18-b4cc-4300d20e809f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equidiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "square"}], "]"}]], "Input",
 CellLabel->
  "In[631]:=",ExpressionUUID->"ee39947d-c42b-1946-824e-37508b741128"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954752189073004*^9, 3.954752199274059*^9}, 
   3.954752247936844*^9, {3.954752559134836*^9, 3.954752562896347*^9}, {
   3.954752652764315*^9, 3.954752673653978*^9}, 3.9611130284945908`*^9, 
   3.9614115966836987`*^9, 3.961413754070294*^9},
 CellLabel->
  "Out[631]=",ExpressionUUID->"b09f5487-2ed4-4713-af49-cf2462e46244"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptB", ",", "ptC"}], "]"}], ",", "square"}], "]"}]], "Input",
 CellChangeTimes->{{3.954726283540348*^9, 3.95472631521429*^9}, {
  3.9547264204545326`*^9, 3.954726422197801*^9}, {3.9547523553753586`*^9, 
  3.954752356161762*^9}, {3.954754242754008*^9, 3.954754242755005*^9}, {
  3.961113030814356*^9, 3.9611130336784573`*^9}},
 CellLabel->
  "In[632]:=",ExpressionUUID->"885ea73e-1757-564a-9c00-d68437911d89"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611130344765625`*^9, 3.961411596743268*^9, 
  3.9614137540793257`*^9},
 CellLabel->
  "Out[632]=",ExpressionUUID->"990d72c6-ce78-44e1-9f4d-4c200d69838f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptA", ",", "ptB"}], "]"}], ",", "square"}], "]"}]], "Input",
 CellLabel->
  "In[633]:=",ExpressionUUID->"2f669f3a-8273-a447-bbb0-087d122ba68a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9547263089588375`*^9, 3.954726423261711*^9, 
  3.954726657374499*^9, 3.954752356895548*^9, 3.9547526753868923`*^9, 
  3.961113036545538*^9, 3.9614115967509947`*^9, 3.961413754152821*^9},
 CellLabel->
  "Out[633]=",ExpressionUUID->"caeeae41-7e89-47d0-98c7-482841b88f1a"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1386, 1148},
WindowMargins->{{200, Automatic}, {Automatic, 4}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f59f3ec9-2c82-e64c-a7b1-bf7907ba01e2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 313, 5, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[896, 29, 1412, 24, 164, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2333, 57, 200, 4, 66, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[2536, 63, 1779, 42, 79, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],
Cell[CellGroupData[{
Cell[4352, 110, 255, 4, 52, "Section",ExpressionUUID->"fd26d20d-f63d-134d-9522-07cd05560e53"],
Cell[4610, 116, 9398, 256, 565, "Input",ExpressionUUID->"40e59fb8-57aa-a44c-b3ad-e5271e9b1dbb"]
}, Closed]],
Cell[CellGroupData[{
Cell[14045, 377, 211, 4, 52, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[14259, 383, 26671, 442, 148, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"],
Cell[40933, 827, 946, 19, 29, "Input",ExpressionUUID->"0d669dd5-dbb6-5146-8f3d-a6e12ef608f4"],
Cell[CellGroupData[{
Cell[41904, 850, 281, 5, 53, "Subsection",ExpressionUUID->"8fd42271-cf5a-0f4a-8f01-7961a2ee714f"],
Cell[CellGroupData[{
Cell[42210, 859, 586, 12, 29, "Input",ExpressionUUID->"d3a0b9b1-1d50-9e4b-8467-aed168b5a1e4"],
Cell[42799, 873, 1486, 42, 33, "Output",ExpressionUUID->"c4e0b672-fb40-4cb5-87b1-5089301134b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44322, 920, 373, 9, 29, "Input",ExpressionUUID->"d222f9f4-9781-3f42-8849-7c89e9a135a7"],
Cell[44698, 931, 273, 5, 33, "Output",ExpressionUUID->"66839b70-e34f-41c0-9912-29ec0c10013d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45020, 942, 204, 4, 37, "Subsection",ExpressionUUID->"990a55c4-883d-5442-8fbf-2dbb85b093b7"],
Cell[CellGroupData[{
Cell[45249, 950, 1308, 36, 31, "Input",ExpressionUUID->"a51e3372-af24-ce43-8f2d-a262f2467327"],
Cell[46560, 988, 37769, 1059, 489, "Output",ExpressionUUID->"f677a9cb-9fb0-4776-815c-a662790e1126"]
}, Open  ]],
Cell[84344, 2050, 221, 5, 33, "Text",ExpressionUUID->"8b9fce3a-19d0-4f46-8ff2-a8f3d086a522"],
Cell[CellGroupData[{
Cell[84590, 2059, 323, 8, 29, "Input",ExpressionUUID->"89436e68-f0dd-e544-8745-b97398d16c1f"],
Cell[84916, 2069, 276, 5, 33, "Output",ExpressionUUID->"05da347e-ef53-4460-b101-31ccbc362722"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85229, 2079, 298, 8, 29, "Input",ExpressionUUID->"12b9d76c-208a-4943-803e-b5b8e79d1a9b"],
Cell[85530, 2089, 273, 5, 33, "Output",ExpressionUUID->"a0570986-25c8-444e-9677-9dec8e3ceb3d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85852, 2100, 397, 6, 37, "Subsection",ExpressionUUID->"4bf33b8f-3b04-5345-986a-164c8bc1a5d5"],
Cell[CellGroupData[{
Cell[86274, 2110, 1152, 36, 31, "Input",ExpressionUUID->"d4b5270a-e4d4-9940-8939-6925cfddae05"],
Cell[87429, 2148, 3332, 105, 57, "Output",ExpressionUUID->"68288e1a-ef0c-4ac1-a352-b9a686fd355e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90798, 2258, 1016, 27, 49, "Input",ExpressionUUID->"8880ba85-22ad-d649-b4c9-ec38ff0e6f28"],
Cell[91817, 2287, 23246, 664, 307, "Output",ExpressionUUID->"87bfb54d-5990-4ba7-99f5-240484103243"]
}, Open  ]],
Cell[115078, 2954, 221, 5, 33, "Text",ExpressionUUID->"e435e2a0-0d6f-7e4b-8e57-4d9e2a83c27e"],
Cell[CellGroupData[{
Cell[115324, 2963, 448, 10, 29, "Input",ExpressionUUID->"583b583c-c47a-4746-8a1b-24153bdbb7a2"],
Cell[115775, 2975, 227, 4, 33, "Output",ExpressionUUID->"dd2ef6e3-c71e-4a7e-9fa0-7132ffea9739"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116039, 2984, 298, 8, 29, "Input",ExpressionUUID->"aaf6b549-d5ad-b442-8e4f-7299e3b31959"],
Cell[116340, 2994, 227, 4, 33, "Output",ExpressionUUID->"a0844f66-94c7-4351-b1cb-a50289a6c25d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116616, 3004, 280, 5, 37, "Subsection",ExpressionUUID->"00923344-6d28-7946-be9c-f9485f0ad95f"],
Cell[CellGroupData[{
Cell[116921, 3013, 1015, 23, 49, "Input",ExpressionUUID->"789bf8c7-b82e-754f-8665-c836edfa3e5d"],
Cell[117939, 3038, 3507, 109, 57, "Output",ExpressionUUID->"8f398744-c46e-42af-a929-dfd66901cd19"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121483, 3152, 530, 11, 29, "Input",ExpressionUUID->"cc2aca6d-779d-2c48-bcdc-172906b0cb64"],
Cell[122016, 3165, 229, 4, 33, "Output",ExpressionUUID->"5d3a642f-7967-4a5f-8ea5-d32be8b58a3e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122282, 3174, 304, 8, 29, "Input",ExpressionUUID->"8bf784d1-ae2d-bf42-a969-ea1992fbc37a"],
Cell[122589, 3184, 324, 5, 33, "Output",ExpressionUUID->"d6932474-81ae-4f08-b46a-e4d25cff7ae3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122950, 3194, 573, 12, 29, "Input",ExpressionUUID->"22fdbcb7-5e8c-ef4e-9db4-1e37754dc718"],
Cell[123526, 3208, 205, 4, 33, "Output",ExpressionUUID->"5bc7e920-e307-4e88-9fbb-b74348c4842c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123768, 3217, 307, 8, 29, "Input",ExpressionUUID->"8e6476d7-c515-0247-8abe-b4af00555518"],
Cell[124078, 3227, 298, 5, 33, "Output",ExpressionUUID->"ff2350ac-e847-45df-8214-3f01f4971ae5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[124425, 3238, 502, 8, 37, "Subsection",ExpressionUUID->"cd88e62b-4c90-f449-9acc-3a1dfa5951b3"],
Cell[CellGroupData[{
Cell[124952, 3250, 1061, 24, 49, "Input",ExpressionUUID->"64df9f36-61ea-2047-87d0-46688453da7b"],
Cell[126016, 3276, 19436, 569, 262, "Output",ExpressionUUID->"fcfce1f5-31f7-47e5-a4ad-1dae7bf9900a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145489, 3850, 526, 11, 29, "Input",ExpressionUUID->"c6d28e61-9a1c-204a-98a3-79b11254dd68"],
Cell[146018, 3863, 205, 4, 33, "Output",ExpressionUUID->"2adb7891-1829-4e6f-bfdb-8ec381a697e0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146260, 3872, 262, 7, 29, "Input",ExpressionUUID->"d0ea322b-4a52-cf42-8296-9d3f28f4f60b"],
Cell[146525, 3881, 378, 6, 33, "Output",ExpressionUUID->"39ce5a9d-b4de-45c7-8ef6-edd3d97d36a6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[146952, 3893, 328, 5, 37, "Subsection",ExpressionUUID->"9e7e0e91-def1-ab49-ad85-568e1ef2b97e"],
Cell[CellGroupData[{
Cell[147305, 3902, 1463, 36, 70, "Input",ExpressionUUID->"e4231648-b7b6-a946-b923-ff6abdb38f26"],
Cell[148771, 3940, 9215, 277, 126, "Output",ExpressionUUID->"f36acee3-b9f0-46c1-be2d-e478ea05ddee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158023, 4222, 528, 11, 29, "Input",ExpressionUUID->"5864f068-f9e6-4645-b8e4-ada1edce89c9"],
Cell[158554, 4235, 203, 4, 33, "Output",ExpressionUUID->"89e023a3-78f1-4f18-b4cc-4300d20e809f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158794, 4244, 262, 7, 29, "Input",ExpressionUUID->"ee39947d-c42b-1946-824e-37508b741128"],
Cell[159059, 4253, 376, 6, 33, "Output",ExpressionUUID->"b09f5487-2ed4-4713-af49-cf2462e46244"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159472, 4264, 571, 12, 29, "Input",ExpressionUUID->"885ea73e-1757-564a-9c00-d68437911d89"],
Cell[160046, 4278, 207, 4, 33, "Output",ExpressionUUID->"990d72c6-ce78-44e1-9f4d-4c200d69838f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160290, 4287, 307, 8, 29, "Input",ExpressionUUID->"2f669f3a-8273-a447-bbb0-087d122ba68a"],
Cell[160600, 4297, 322, 5, 33, "Output",ExpressionUUID->"caeeae41-7e89-47d0-98c7-482841b88f1a"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

